Imports System.Diagnostics
Imports System.IO

Module Module1

#If False Then
  Sub Main()
    Dim EventLog As New EventLog("Application", ".", "WriteToEventLog")

    Dim Listener As New EventLogTraceListener(EventLog)
    Trace.Listeners.Add(Listener)
    Trace.WriteLine(Command())
  End Sub
#End If

#If True Then

  Private Const EventSourceName As String = "WriteToEventLog"
  'Private Const EventSourceName As String = "AAA"

  Sub Main()
    CheckEventSource()

    Dim Log As New EventLog()
    Try
      Log.Source = EventSourceName
      Log.WriteEntry(Command())
    Finally
      Log.Close()
    End Try

    DeleteEventSource()
  End Sub


  Private Function SourceExists() As Boolean
    Return EventLog.SourceExists(EventSourceName)
  End Function

  Private Sub CreateEventSource()
    EventLog.CreateEventSource(EventSourceName, "Application")
  End Sub

  Private Sub CheckEventSource()
    If (Not SourceExists()) Then
      CreateEventSource()
    End If
  End Sub

  Private Sub DeleteEventSource()
    If (SourceExists()) Then
      EventLog.DeleteEventSource(EventSourceName)
    End If
  End Sub

#End If

End Module
